package com.bxm.localnews.news.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;


/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {


    /**
     * ====================================================================== news 模块相关缓存键值 用户阅读推荐新闻获得奖励的次数
     */
    public static KeyGenerator RECOMMEND_NEWS_READ = DefaultKeyGenerator.build("news", "recommendNewsRead");

    /**
     * 用户阅读新闻获得奖励的次数
     */
    public static KeyGenerator NEWS_READ = DefaultKeyGenerator.build("news", "readnews");

    /**
     * 新闻类型缓存
     */
    public static KeyGenerator NEWS_KIND = DefaultKeyGenerator.build("news", "cache", "newskind");

    /**
     * 全局的新闻屏蔽key
     */
    public static KeyGenerator NEWS_SHIELD = DefaultKeyGenerator.build("news", "shield");

    /**
     * 新闻静态数据存放
     */
    public static KeyGenerator NEWS_STATISTIC = DefaultKeyGenerator.build("news", "statistic");

    /**
     * 推荐给个人用户的小视频缓存，30分钟有效期
     */
    public static KeyGenerator VIDEO_RECOMMEND = DefaultKeyGenerator.build("video", "usercache");

    /**
     * 推荐给个人用户的小视频缓存，2小时有效期
     */
    public static KeyGenerator NEWS_RECOMMEND = DefaultKeyGenerator.build("news", "usercache");

    /**
     * 用户推荐新闻间隔
     */
    public static KeyGenerator NEWS_RECOMMEND_INTERVAL = DefaultKeyGenerator.build("news", "recommend",
            "interval");

    /**
     * 用户频道缓存
     */
    public static KeyGenerator NEWS_USER_KIND = DefaultKeyGenerator.build("news", "kind", "user_list");

    /**
     * 用户频道set缓存
     */
    public static KeyGenerator NEWS_USER_KIND_SET = DefaultKeyGenerator.build("news", "kind", "user_set");

    /**
     * 小视频队列
     */
    public static KeyGenerator VIDEO_QUEUE = DefaultKeyGenerator.build("video", "queue");

    /**
     * 新闻队列
     */
    public static KeyGenerator NEWS_QUEUE = DefaultKeyGenerator.build("news", "queue");

    /**
     * 首页置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页区域性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_AREA_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页全国性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_WHOLE_COUNTRY_LIST = DefaultKeyGenerator.build("news", "top",
            "wholeCountry");

    /**
     * 用户当日分享新闻记录 ,有效期:当天
     */
    public static KeyGenerator USER_SHARE_NEWS_RECORD = DefaultKeyGenerator.build("activity", "task",
            "usersharenews");

    /**
     * 帖子id生成规则
     */
    public static KeyGenerator SEQ_POST_ID = DefaultKeyGenerator.build("seq", "post", "id");

    /**
     * 活动帖子的ID生成
     */
    public static KeyGenerator SEQ_ACTIVITY_POST_ID = DefaultKeyGenerator.build("seq", "activity_post", "id");

    /**
     * 用户首次进入推广地区
     */
    public static KeyGenerator FIRST_ENTER_PROMOTION_AREA = DefaultKeyGenerator.build("news", "user", "fistPromotion");

    /**
     * 论坛帖子推荐相关模块
     */
    public static KeyGenerator FORUM_RECOMMENDED = DefaultKeyGenerator.build("forum", "recommended");

    /**
     * 论坛帖子相关模块
     */
    public static KeyGenerator FORUM_INFO = DefaultKeyGenerator.build("forum", "info");

    /**
     * 用户当天点赞帖子次数
     */
    public static KeyGenerator FORUMPOST_LIEK_TIME = DefaultKeyGenerator.build("activity", "task", "forumpostLikeTime");

    /**
     * 社区版块缓存
     */
    public static KeyGenerator FORUM = DefaultKeyGenerator.build("forum", "cache", "forum");

    /**
     * 社区话题缓存
     */
    public static KeyGenerator TOPIC = DefaultKeyGenerator.build("forum", "cache", "topic");

    /**
     * 单个话题详情，hash结构
     */
    public static KeyGenerator TOPIC_DETAIL = DefaultKeyGenerator.build("news", "cache", "topic");

    /**
     * 不同地区的话题列表,hash结构
     * key：地区编码
     * value：地区对应的话题列表
     */
    public static KeyGenerator TOPIC_AREA_LIST = DefaultKeyGenerator.build("news", "cache", "topic_list");

    /**
     * 新建奖励帖子轮播信息
     */
    public static KeyGenerator FORUM_POST_REWARD_LIST = DefaultKeyGenerator.build("forum", "post", "reward_list");

    /**
     * 用户查看推荐话题序数
     */
    public static KeyGenerator USER_READ_RECOMMEND_TOPIC = DefaultKeyGenerator.build("forum", "recommend_topic", "user_read_order");

    /**
     * H5站外访问帖子记录
     */
    public static KeyGenerator FORUM_RECORD_FROM_H5 = DefaultKeyGenerator.build("forum", "record", "h5");

    /**
     * 帖子点赞分布式锁key
     */
    public static KeyGenerator FORUMPOST_LIKE_LOCK = DefaultKeyGenerator.build("forumpost", "like", "lock");

    /**
     * 新人发帖分布式锁key
     */
    public static KeyGenerator NEW_REPORT_LOCK = DefaultKeyGenerator.build("forumpost", "new_report", "lock");

    /**
     * 操作评论分布式锁key
     */
    public static KeyGenerator REPLY_UPDATE_OWNER_HOT = DefaultKeyGenerator.build("reply", "updateOwnerAndHot", "lock");

    /**
     * 视频转码缓存
     */
    public static KeyGenerator VIDEO_TRANSCODE = DefaultKeyGenerator.build("video", "transcode");

    /**
     * 视频转码映射缓存，供定时任务调用并替换
     */
    public static KeyGenerator VIDEO_TRANSCODE_MAP = DefaultKeyGenerator.build("video", "transcode_map", "list");

    /**
     * 视频转码映射执行缓存
     */
    public static KeyGenerator VIDEO_TRANSCODE_MAP_EXEC = DefaultKeyGenerator.build("video", "transcode_map", "exec_list");

    /**
     * 视频转码映射执行缓存
     */
    public static KeyGenerator RECENT_DEVELOPMENTS = DefaultKeyGenerator.build("user", "recent_developments", "list");

    /**
     * 用户帖子图片、视频缓存
     */
    public static KeyGenerator USER_FORUM_IMG = DefaultKeyGenerator.build("user", "forum", "img");

    /**
     * 用户小纸条缓存
     */
    public static KeyGenerator USER_FORUM_NOTE = DefaultKeyGenerator.build("user", "note", "common");

    /**
     * 用户发布小纸条次数
     */
    public static KeyGenerator USER_NOTE_PUBLISH = DefaultKeyGenerator.build("user", "note", "publish");

    /**
     * 小纸条每日发布数
     */
    public static KeyGenerator NOTE_DAILY_PUBLISH_NUM = DefaultKeyGenerator.build("note", "daily", "publish_num");

    /**
     * 统计一段时间帖子内评论数量,用来定时发送评论回复提醒
     */
    public static KeyGenerator FORUM_REPLY_INFO = DefaultKeyGenerator.build("forum", "reply", "info");


    /**
     * 统计一段时间帖子内评论数量,用来定时发送评论回复提醒
     */
    public static KeyGenerator FORUM_REPLY_POSTID = DefaultKeyGenerator.build("forum", "reply", "postId");

    /**
     * 用户聊天阅读过的小纸条
     */
    public static KeyGenerator USER_READ_NOTE = DefaultKeyGenerator.build("im", "note", "read");

    /**
     * 每个地区的阅读量最高的帖子
     */
    public static KeyGenerator AREA_TOP_POST = DefaultKeyGenerator.build("news", "cache", "topPost");

    /**
     * 公共标签记录
     */
    public static final KeyGenerator SPIDER_TAG_INDEX = DefaultKeyGenerator.build("sync", "spider", "tag");

    /**
     * 全局的新闻黑名单key
     */
    public static KeyGenerator NEWS_BLACK = DefaultKeyGenerator.build("news", "black");

    public static KeyGenerator SEQ_NEWS_ID = DefaultKeyGenerator.build("seq", "news", "id");

    /**
     * 各个地区的面包块新增消息总数
     */
    public static KeyGenerator CRUMBS_AREA_TOTAL = DefaultKeyGenerator.build("forum", "crumbs", "total");

    /**
     * 本地圈面包块消息用户已读数量
     */
    public static KeyGenerator CRUMBS_READ_COUNT = DefaultKeyGenerator.build("forum", "crumbs", "read");


    /**
     * 用户帖子教育缓存
     */
    public static KeyGenerator FORUM_TEACH_CACHE = DefaultKeyGenerator.build("forum", "cache", "forumTeach");

    /**
     * 全国贴和小纸条新增消息总数
     */
    public static KeyGenerator NATIONAL_AREA_TOTAL = DefaultKeyGenerator.build("forum", "crumbs", "nationalTotal");

    /**
     * 热门贴排行缓存key
     */
    public static KeyGenerator FORUM_HOT_LIST = DefaultKeyGenerator.build("forum", "hot", "rank");

    /**
     * 本地圈 提示发帖弹窗   一天只显示一次
     */
    public static KeyGenerator FORUM_POST_POP_ONEDAY = DefaultKeyGenerator.build("forum", "postPop", "warn");

    /**
     * 热门帖子上榜推送缓存key
     */
    public static KeyGenerator FORUM_HOT_PUSH_KEY = DefaultKeyGenerator.build("forum", "hot", "push");

    /**
     * 3.10.0  话题下帖子带图缓存 限制个数
     */
    public static KeyGenerator FORUM_LIMITNUM_TOPIC = DefaultKeyGenerator.build("forum", "img_info", "topic");

    public static KeyGenerator FORUM_LIMITNUM_TOPIC_NEW = DefaultKeyGenerator.build("forum", "img_info_new", "topic");

    /**
     * 3.10.0 话题发帖引导弹窗 一天每个用户弹一次
     */
    public static KeyGenerator TOPIC_DETAIL_GUIDE_HAS_POP_LIST = DefaultKeyGenerator.build("forum", "topic_guider", "pop");

    /**
     * 话题下的热门帖子，根据地区进行区分
     */
    public static KeyGenerator TOPIC_HOT_POST_CACHE_KEY = DefaultKeyGenerator.build("forum", "topic_hot_post", "cache");

    /**
     * 热文分享帖子奖金key
     */
    public static KeyGenerator SHARE_POST_AWARD_KEY = DefaultKeyGenerator.build("forum", "share_post", "award");

    /**
     * 今日参与热文分享阅读用户集合key
     */
    public static KeyGenerator TODAY_JOIN_SHARE_POST_USER_KEY = DefaultKeyGenerator.build("forum", "share_post", "join_user");

    /**
     * 活动帖子参与活动用户信息
     */
    public static KeyGenerator ACTIVITY_POST_JOIN_USER_KEY = DefaultKeyGenerator.build("forum", "activity_post", "join_user");

    /**
     * 后台管理保存或者更新帖子分布式锁
     */
    public static KeyGenerator SAVE_OR_UPDATE_POST_KEY = DefaultKeyGenerator.build("forum", "admin_post", "save_or_update");

    /**
     * 新增热文帖子时初始化一个随机奖励
     */
    public static KeyGenerator HOT_POST_INIT_RANDOM_AWARD_KEY = DefaultKeyGenerator.build("forum", "share_post", "random_award");

}
