package com.bxm.localnews.news.enums;

/**
 * 数据转换接口，将原始数据转换为目标数据结构
 *
 * @param <T> 原始数据类型
 * @param <K> 目标数据类型
 */
public interface Converter<T, K> {

    /**
     * 进行数据转换操作
     * 提取extract  特征 feature
     *
     * @param data 原始数据
     * @return 转换后的数据
     */
    K convert(T data);
}
