package com.bxm.localnews.news.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * <p>
 * 运营位枚举值
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/3
 */
public enum OperationLocationEnum {
    /**
     * 不同的帖子显示列表
     */
    HOME_PAGE(1, "头条首页"),
    FORUM_HOME_PAGE(2, "社区首页"),
    FORUM_TOPIC_NEWEST(3, "话题最新"),
    FORUM_TOPIC_HOT(4, "话题热门"),
    FORUM_PLATE_NEWEST(5, "话题最新"),
    FORUM_PLATE_ELITE(6, "板块精华"),
    FORUM_POST_DETAIL(7, "帖子详情相关推荐"),
    NEWS_DETAIL(8, "新闻详情"),
    NOTE_DETAIL(9, "小纸条详情"),
    ;

    private int code;

    private String name;

    OperationLocationEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getName(int code) {
        for (OperationLocationEnum operation : OperationLocationEnum.values()) {
            if (code == operation.getCode()) {
                return operation.getName();
            }
        }
        return StringUtils.EMPTY;
    }
}
