package com.bxm.localnews.news.enums;

import java.util.Objects;

/**
 * 帖子状态枚举类
 *
 * @author stephen
 */
public enum PostStatusEnum {
    /**
     * 用户可见的帖子状态
     */
    NORMAL(1, "正常显示"),

    /**
     * 审核中，当前用户可见，需要限制传播，其他用户不可见
     */
    APPROVING(2, "审核中"),

    /**
     * 审核被拒，发布用户可见，其他用户不可见
     */
    REJECTED(3, "被拒绝"),

    /**
     * 被用户主动删除，保留数据，所有人不可见
     */
    USER_DELETE(4, "用户删除"),

    /**
     * 发布人无感知，仅发布人可见
     */
    SELF(5, "仅楼主可见"),

    /**
     * 不显示在本地圈，发布人可见
     */
    BLOCKED(6, "本地圈屏蔽"),

    /**
     * 所有人不可见，但是备注是被运营删除
     */
    OPERATOR_DELETE(7, "运营删除"),
    ;

    PostStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    private Integer code;

    private String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    /**
     * 根据编码获取帖子状态
     *
     * @param code 帖子状态编码
     * @return 帖子状态枚举，如果状态不匹配，则返回null
     */
    public static PostStatusEnum getByCode(Integer code) {
        for (PostStatusEnum value : values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }

        return null;
    }
}
