package com.bxm.localnews.news.enums;

/**
 * 帖子类型枚举类
 *
 * @author stephen
 */
public enum PostTypeEnum {

    COMMON((byte) 1, "普通帖子"),
    NOTE((byte) 2, "小纸条"),
    ACTIVITY((byte) 3, "活动帖子"),
    ;

    PostTypeEnum(byte code, String name) {
        this.code = code;
        this.name = name;
    }

    private byte code;

    private String name;

    public byte getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
