package com.bxm.localnews.news.enums;

import java.util.Objects;

/**
 * 推荐库内容类型
 *
 * @author liujia
 */
public enum RecommendContentTypeEnum {

    /**
     * 放入到推荐库的不同内容的类型，方便查询和使用
     */
    FORUM_POST(1, "社区帖子"),
    ACTIVITY_POST(2, "活动帖子"),
    NOTE(3, "小纸条"),
    NEWS(4, "新闻"),
    SHARE_CASH_POST(5, "热文帖子"),
    ;

    RecommendContentTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RecommendContentTypeEnum getByCode(Integer code) {
        for (RecommendContentTypeEnum value : values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }

        return FORUM_POST;
    }

    private Integer code;

    private String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
