package com.bxm.localnews.news.enums;

import lombok.Getter;

/**
 * 审核状态
 */
@Getter
public enum ReplyStatusEnum {

    /**
     *
     */
    BE_SHOW((byte) 0, "待展示"),

    IS_SHOW((byte) 1, "已展示"),

    WAIT_REVIEW((byte) 2, "待审核"),

    REFUSE((byte) 3, "审核拒绝"),

    SELF((byte) 4, "仅自己可见"),

    USER_DELETE((byte) 105, "用户删除（伪造的状态）"),

    MANAGE_DELETE((byte) 106, "运营删除（伪造的状态）"),
    ;


    private byte code;

    private String desc;

    ReplyStatusEnum(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

}
