package com.bxm.localnews.news.enums;

/**
 * @author zhaoyadong 2018/10/20 14:40
 * @desc
 */
public enum SensitiveFlagEnum {

    IS_NOT_SENSITIVE((byte) 0, "不是敏感内容"),
    IS_SENSITIVE((byte) 1, "敏感内容");

    private Byte state;

    private String name;

    SensitiveFlagEnum(Byte state, String name) {
        this.state = state;
        this.name = name;
    }

    public static SensitiveFlagEnum getSensitiveFlagEnum(Byte state) {

        for (SensitiveFlagEnum sensitiveFlagEnum : SensitiveFlagEnum.values()) {
            if (sensitiveFlagEnum.getState().equals(state)) {
                return sensitiveFlagEnum;
            }
        }

        return null;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
