package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户发帖事件
 *
 * @author liujia
 * @date 2020-07-16 19:13
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class ForumPostActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.FORUM_POST;

    /**
     * 最后发帖ID
     */
    private Long lastPostId;

    /**
     * 最后发帖事件
     */
    private Date lastPostTime;
}