package com.bxm.localnews.news.event;

import org.springframework.context.ApplicationEvent;

/**
 * 评论审核通过的事件
 * @author gonzo
 * @date 2021-03-12 11:17
 **/
public class ReplyAccessApplicationEvent extends ApplicationEvent {

    /**
     * 评论id
     */
    private Long replyId;

    /**
     * 帖子id
     */
    private Long newsId;
    /**
     * Create a new ApplicationEvent.
     *
     * @param replyId 评论id
     */
    public ReplyAccessApplicationEvent(Long replyId, Long newsId) {
        super(replyId);
        this.replyId = replyId;
        this.newsId = newsId;
    }

    public Long getReplyId() {
        return replyId;
    }

    public Long getNewsId() {
        return newsId;
    }
}
