package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 视频浏览完成事件
 *
 * @author liujia
 * @date 2020-07-16 19:53
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class VideoViewActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.VIDEO_VIEW;

    /**
     * 浏览的视频ID
     */
    private Long videoId;

    /**
     * 浏览时长
     */
    private Integer viewTime;

    /**
     * 是否完整浏览，true表示完整浏览
     */
    private Integer fullView;
}
