package com.bxm.localnews.news.factory;


import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.url.ProtocolFactory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * 各种路由地址拼接
 *
 * @author shentao
 */
@Component
@AllArgsConstructor
public class IUrlFactory {

    private BizConfigProperties bizConfigProperties;

    public String getAppUrl(UrlCategoryEnum urlCategoryEnum, UrlTypeEnum urlTypeEnum, Long id, Long userId) {
        if (UrlCategoryEnum.NEWS.equals(urlCategoryEnum)) {
            if (UrlTypeEnum.DETAIL.equals(urlTypeEnum)) {
                return ProtocolFactory.news().inner().newsId(id).type(1).userId(userId).build();
            } else if (UrlTypeEnum.SHARE.equals(urlTypeEnum)) {
                return ProtocolFactory.news().outer().newsId(id).userId(userId).type(2).build();
            }
        } else if (UrlCategoryEnum.FORUM.equals(urlCategoryEnum)) {
            if (UrlTypeEnum.TOPIC.equals(urlTypeEnum)) {
                return ProtocolFactory.topic().outer().userId(userId).topicId(id).build();
            } else if (UrlTypeEnum.SHARE.equals(urlTypeEnum)) {
                return ProtocolFactory.forumPost().outer().userId(userId).postId(id).build();
            }
        }
        return null;
    }

    public String getAppletUrl(UrlPositionEnum urlPositionEnum, Long id, Long userId) {
        switch (urlPositionEnum) {
            case BLOCK:
                return bizConfigProperties.getAppletServerHost() + "?tp=block&id=" + id + "&isShare=1&uid=" + userId;
            case TOPIC:
                return bizConfigProperties.getAppletServerHost() + "?tp=topic&id=" + id + "&isShare=1&uid=" + userId;
            case POST:
                return bizConfigProperties.getAppletServerHost() + "?tp=post&id=" + id + "&isShare=1&uid=" + userId;
            case NEWS:
                return bizConfigProperties.getAppletServerHost() + "?tp=news&id=" + id + "&isShare=1&uid=" + userId;
            case MANLL_HOME:
                return bizConfigProperties.getAppletServerHost() + "?tp=manllHome&id=" + id + "&isShare=1&uid=" + userId;
            default:
                return null;
        }
    }
}
