package com.bxm.localnews.news.util;

import com.bxm.newidea.component.tools.HtmlContentUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

/**
 * @author stephen
 * @desc 内容处理工具类
 */
@Slf4j
@Component
public class HtmlContentUtil {

    /**
     * 处理帖子中的textFiled不能换行
     *
     * @param content
     * @return
     */
    public static String getForumPostTextFiled(String content) {
        Document document = Jsoup.parse(content);
        Elements elements = document.select("p");
        StringBuilder sb = new StringBuilder();
        for (Element element : elements) {
            String text = element.text();
            String result = HtmlContentUtils.delHtmlTags(text);
            if (StringUtils.isNotBlank(result)) {
                if (sb.length() == 0) {
                    sb.append(result);
                } else {
                    sb.append("\n").append(result);
                }
            }
        }
        return sb.toString();
    }
}
