package com.bxm.localnews.news.util;

import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 运营后台权限工具接口
 *
 * @author liujia
 * @date 2020-08-06 16:13
 **/
public class SecurityUtils {

    private SecurityUtils() {
    }

    public static Long getAdminUserId() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();

        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
            HttpServletRequest request = servletRequestAttributes.getRequest();

            String currentUserId = request.getHeader("currentUserId");

            if (NumberUtils.isDigits(currentUserId)) {
                return Long.valueOf(currentUserId);
            }
        }

        return 0L;
    }
}
