package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用户定位信息配置实体
 *
 * @author
 */
public class Location implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 地区编码
     */
    private String code;

    /**
     * 地区简称
     */
    private String name;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 是否热门城市（1表示true）
     */
    private Byte hot;

    /**
     * 是否显示（1表示true）
     */
    private Byte show;

    /**
     * 城市级别（2：市、3：县（区））
     */
    private Byte level;

    /**
     * 城市拼音或者首字母
     */
    private String pinyin;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 经度
     */
    private Double lng;

    /**
     * 是否启用VIP
     */
    private Byte enableVip;

    /**
     * 激活VIP需要邀请人数
     */
    private Integer invitedCount;

    /**
     * 优惠金额
     */
    private String reductionAmount;

    @ApiModelProperty("是否启用推广赚钱")
    private Byte enablePaidPromote;

    @ApiModelProperty("新人红包金额")
    private BigDecimal newRedPacket = BigDecimal.ZERO;

    @ApiModelProperty("推广赏金")
    private BigDecimal promoteBounty = BigDecimal.ZERO;

    /**
     * 是否启用社区内容，1：启用，0：禁用
     */
    private Integer enableCommunityContent;

    /**
     * 是否启用首页发帖，1：启用，0：禁用
     */
    private Integer enableIndexPublish;

    /**
     * 是否启用客服小助手，1：启用，0：禁用
     */
    private Integer enableCustomerService;

    /**
     * 客服微信号
     */
    private String customerServiceNumber;

    /**
     * 客服二维码
     */
    private String customerServiceQrCode;

    /**
     * 是否开启聊天室
     */
    private Byte enableChatRoom;

    /**
     * 最新的行政编码
     */
    private String lastCode;

    public String getLastCode() {
        return lastCode;
    }

    public void setLastCode(String lastCode) {
        this.lastCode = lastCode;
    }

    public Byte getEnablePaidPromote() {
        return enablePaidPromote;
    }

    public void setEnablePaidPromote(Byte enablePaidPromote) {
        this.enablePaidPromote = enablePaidPromote;
    }

    public BigDecimal getNewRedPacket() {
        return newRedPacket;
    }

    public void setNewRedPacket(BigDecimal newRedPacket) {
        this.newRedPacket = newRedPacket;
    }

    public BigDecimal getPromoteBounty() {
        return promoteBounty;
    }

    public void setPromoteBounty(BigDecimal promoteBounty) {
        this.promoteBounty = promoteBounty;
    }

    public Byte getEnableVip() {
        return enableVip;
    }

    public void setEnableVip(Byte enableVip) {
        this.enableVip = enableVip;
    }

    public Integer getInvitedCount() {
        return invitedCount;
    }

    public void setInvitedCount(Integer invitedCount) {
        this.invitedCount = invitedCount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Byte getShow() {
        return show;
    }

    public void setShow(Byte show) {
        this.show = show;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public String getPinyin() {
        return pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public String getReductionAmount() {
        return reductionAmount;
    }

    public void setReductionAmount(String reductionAmount) {
        this.reductionAmount = reductionAmount;
    }

    public Integer getEnableCommunityContent() {
        return enableCommunityContent;
    }

    public void setEnableCommunityContent(Integer enableCommunityContent) {
        this.enableCommunityContent = enableCommunityContent;
    }

    public Integer getEnableIndexPublish() {
        return enableIndexPublish;
    }

    public void setEnableIndexPublish(Integer enableIndexPublish) {
        this.enableIndexPublish = enableIndexPublish;
    }

    public Integer getEnableCustomerService() {
        return enableCustomerService;
    }

    public void setEnableCustomerService(Integer enableCustomerService) {
        this.enableCustomerService = enableCustomerService;
    }

    public String getCustomerServiceNumber() {
        return customerServiceNumber;
    }

    public void setCustomerServiceNumber(String customerServiceNumber) {
        this.customerServiceNumber = customerServiceNumber;
    }

    public String getCustomerServiceQrCode() {
        return customerServiceQrCode;
    }

    public void setCustomerServiceQrCode(String customerServiceQrCode) {
        this.customerServiceQrCode = customerServiceQrCode;
    }

    public Byte getEnableChatRoom() {
        return enableChatRoom;
    }

    public void setEnableChatRoom(Byte enableChatRoom) {
        this.enableChatRoom = enableChatRoom;
    }
}