package com.bxm.localnews.url;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 站内H5访问协议地址
 *
 * @author liujia
 * @date 1/20/21 4:53 PM
 **/
@Slf4j
public class H5UrlProtocolBuilder extends AbstractProtocolBuilder {
    H5UrlProtocolBuilder(DomainIntegrationService domainIntegrationService) {
        super(domainIntegrationService);
    }

    private String url;

    public H5UrlProtocolBuilder url(String url) {
        this.url = url;
        return this;
    }

    public String build() {
        try {
            url = URLEncoder.encode(url, Charsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "wst://web/webDetail?url=" + url;
    }
}
