package com.bxm.localnews.url;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import org.apache.commons.lang3.StringUtils;

/**
 * 新闻的相关协议构建
 *
 * @author liujia
 * @date 1/20/21 3:06 PM
 **/
public class NewsProtocolBuilder extends AbstractProtocolBuilder {

    NewsProtocolBuilder(DomainIntegrationService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建站外分享地址
     */
    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    /**
     * 构建站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public InnerProtocolBuilder inner() {
        return new InnerProtocolBuilder();
    }

    public class InnerProtocolBuilder {

        private Long newsId;

        private Long userId;

        private String areaCode;

        private boolean noExtend;

        private Integer type;

        public InnerProtocolBuilder noExtend() {
            this.noExtend = true;
            return this;
        }

        public InnerProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public InnerProtocolBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public InnerProtocolBuilder newsId(Long newsId) {
            this.newsId = newsId;
            return this;
        }

        public InnerProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getInnerH5BaseUrl();

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/newsDetail.html?newsId=").append(newsId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (null != type) {
                url.append("&type=").append(type);
            }
            if (noExtend) {
                url.append("&noExtend=1");
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }

            return url.toString();
        }
    }

    public class OuterProtocolBuilder {

        private Long newsId;

        private Long userId;

        private String areaCode;

        private String cityName;

        private boolean noExtend;

        private String channel;

        private Integer type;

        private DomainScene.DomainViewScene domainViewScene = DomainScene.DomainViewScene.WX_JS_VIEW;

        public OuterProtocolBuilder noExtend() {
            this.noExtend = true;
            return this;
        }

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public OuterProtocolBuilder newsId(Long newsId) {
            this.newsId = newsId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder cityName(String cityName) {
            this.cityName = cityName;
            return this;
        }

        public OuterProtocolBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public OuterProtocolBuilder domainViewScene(DomainScene.DomainViewScene domainViewScene) {
            this.domainViewScene = domainViewScene;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getOutSideShareBaseUrl(domainViewScene);
            if (!DomainScene.DomainViewScene.CONTENT_VIEW.equals(domainViewScene)
                    && StringUtils.isBlank(baseUrl)) {
                baseUrl = domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW);
            }

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareNewsDetail.html?newsId=").append(newsId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (null != type) {
                url.append("&type=").append(type);
            }
            if (null != channel) {
                url.append("&channel=").append(channel);
            }
            if (noExtend) {
                url.append("&noExtend=1");
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }
            if (null != cityName) {
                url.append("&cityName=").append(cityName);
            }

            return url.toString();
        }
    }

    public class AppProtocolBuilder {
        private Long newsId;

        public AppProtocolBuilder newsId(Long newsId) {
            this.newsId = newsId;
            return this;
        }

        public String build() {
            return "wst://news/newsDetail?newsId=" + newsId + "&tp=news";
        }
    }
}
