package com.bxm.localnews.url;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import org.apache.commons.lang3.StringUtils;

/**
 * 帖子的相关协议构建
 *
 * @author liujia
 * @date 1/20/21 3:06 PM
 **/
public class PostProtocolBuilder extends AbstractProtocolBuilder {

    PostProtocolBuilder(DomainIntegrationService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建帖子的站外分享地址
     */
    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    /**
     * 构建帖子的站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class OuterProtocolBuilder {

        private Long postId;

        private Long userId;

        private String areaCode;

        private String cityName;

        private boolean noExtend;

        private String channel;

        /**
         * 管理后台用：为true不上报奖励
         */
        private boolean debug;

        private DomainScene.DomainViewScene domainViewScene = DomainScene.DomainViewScene.WX_JS_VIEW;

        public OuterProtocolBuilder noExtend() {
            this.noExtend = true;
            return this;
        }

        public OuterProtocolBuilder debug() {
            this.debug = true;
            return this;
        }

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder postId(Long postId) {
            this.postId = postId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder cityName(String cityName) {
            this.cityName = cityName;
            return this;
        }

        public OuterProtocolBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public OuterProtocolBuilder domainViewScene(DomainScene.DomainViewScene domainViewScene) {
            this.domainViewScene = domainViewScene;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getOutSideShareBaseUrl(domainViewScene);
            if (!DomainScene.DomainViewScene.CONTENT_VIEW.equals(domainViewScene)
                    && StringUtils.isBlank(baseUrl)) {
                baseUrl = domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW);
            }

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareInvitationDetail.html?id=").append(postId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }
            if (null != cityName) {
                url.append("&cityName=").append(cityName);
            }
            if (null != channel) {
                url.append("&channel=").append(channel);
            }
            if (noExtend) {
                url.append("&noExtend=1");
            }
            if (debug) {
                url.append("&debug=true");
            }

            return url.toString();
        }
    }

    public class AppProtocolBuilder {
        private Long postId;

        public AppProtocolBuilder postId(Long postId) {
            this.postId = postId;
            return this;
        }

        public String build() {
            return "wst://community/postDetail?postId=" + postId + "&tp=post";
        }
    }
}
