package com.bxm.localnews.url;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.newidea.component.tools.SpringContextHolder;

/**
 * 协议地址构建工厂，对外提供统一的类
 * 具体协议的构建类不对外暴露
 *
 * @author liujia
 * @date 1/20/21 3:02 PM
 **/
public class ProtocolFactory {

    private static DomainIntegrationService domainIntegrationService;

    private static DomainIntegrationService getDomainIntegrationService() {
        if (domainIntegrationService == null) {
            domainIntegrationService = SpringContextHolder.getBean(DomainIntegrationService.class);
        }
        return domainIntegrationService;
    }

    /**
     * 构建帖子详情的相关协议
     */
    public static PostProtocolBuilder forumPost() {
        return new PostProtocolBuilder(getDomainIntegrationService());
    }

    /**
     * 新闻详情的相关协议
     */
    public static NewsProtocolBuilder news() {
        return new NewsProtocolBuilder(getDomainIntegrationService());
    }

    /**
     * app内部的H5链接地址
     */
    public static H5UrlProtocolBuilder appH5() {
        return new H5UrlProtocolBuilder(getDomainIntegrationService());
    }

    /**
     * 话题详情协议地址
     */
    public static TopicProtocolBuilder topic() {
        return new TopicProtocolBuilder(getDomainIntegrationService());
    }

    /**
     * 个人中心协议地址
     */
    public static HomeProtocolBuilder home() {
        return new HomeProtocolBuilder(getDomainIntegrationService());
    }

    /**
     * 商户 - 商品详情地址
     */
    public static GoodsDetailProtocolBuilder goods() {
        return new GoodsDetailProtocolBuilder(getDomainIntegrationService());
    }
}
