package com.bxm.localnews.url;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;

/**
 * 话题协议跳转
 *
 * @author liujia
 * @date 1/20/21 5:06 PM
 **/
public class TopicProtocolBuilder extends AbstractProtocolBuilder {

    TopicProtocolBuilder(DomainIntegrationService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建站外分享地址
     */
    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    /**
     * 构建站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class OuterProtocolBuilder {

        private Long topicId;

        private Long userId;

        private String areaCode;

        private String areaName;

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder topicId(Long topicId) {
            this.topicId = topicId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder areaName(String areaName) {
            this.areaName = areaName;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW);

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareTopicDetail.html");
            url.append("?id=").append(topicId);

            if (null != userId) {
                url.append("&userId=").append(userId);
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }
            if (null != areaName) {
                url.append("&areaName=").append(areaName);
            }

            return url.toString();
        }
    }

    public class AppProtocolBuilder {
        private Long topicId;

        public AppProtocolBuilder topicId(Long topicId) {
            this.topicId = topicId;
            return this;
        }

        public String build() {
            return "wst://community/topicDetail?tp=topic&topicId=" + topicId + "";
        }
    }
}
