package com.bxm.localnews.news.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.dto.BaseForumPostDTO;
import com.bxm.localnews.news.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.dto.InteractRankInfo;
import com.bxm.localnews.news.dto.ShareContentDTO;
import com.bxm.localnews.news.param.ForumPostFacadeParam;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ShareRankService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "4-95 [内部]帖子接口")
@RestController
@RequestMapping("facade/forumPost")
public class ForumPostFacadeController {

    private final ForumPostService forumPostService;

    private final ForumPostFacadeService forumPostFacadeService;

    private final ShareRankService shareRankService;

    @Autowired
    public ForumPostFacadeController(ForumPostService forumPostService,
                                     ForumPostFacadeService forumPostFacadeService,
                                     ShareRankService shareRankService) {
        this.forumPostService = forumPostService;
        this.forumPostFacadeService = forumPostFacadeService;
        this.shareRankService = shareRankService;
    }

    @ApiOperation(value = "4-95-1 生成帖子")
    @PostMapping("createPost")
    public Boolean createPost(@RequestBody ForumBasicVo forumBasicVo) {
        forumPostService.doCreateOrUpdatePost(forumBasicVo, null, true);
        return true;
    }

    @ApiOperation(value = "4-95-2 获得用户发帖数量")
    @PostMapping("getPublishPostNum")
    public Integer createPost(@RequestParam("userId") Long userId) {
        return forumPostFacadeService.getPublishPostNum(userId);
    }

    @ApiOperation(value = "4-95-3 根据阅读数限制获取发布时间在一天内的帖子")
    @PostMapping("getRecentPosts")
    public List<ForumPostClickCountVo> getRecentPosts(@RequestParam("clickCountLimit") Integer clickCountLimit) {
        return forumPostFacadeService.getRecentPosts(clickCountLimit);
    }

    @ApiOperation(value = "4-95-4 批量增加帖子阅读数")
    @PostMapping("batchAddClick")
    public void batchAddClick(@RequestParam(value = "forumPostClickListJson") String forumPostClickListJson) {
        forumPostFacadeService.batchAddClick(JSON.parseArray(forumPostClickListJson, ForumPostClickCountVo.class));
    }

    @ApiOperation(value = "4-95-5 获取帖子简略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "访问请求来源用户所属区域编码"),
            @ApiImplicitParam(name = "areaName", value = "访问请求来源用户所属区域名称"),
            @ApiImplicitParam(name = "userId", value = "访问接口的用户ID")
    })
    @GetMapping("briefInfo")
    public ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(@RequestParam("postId") Long postId,
                                                              @RequestParam(value = "areaCode", required = false) String areaCode,
                                                              @RequestParam(value = "areaName", required = false) String areaName,
                                                              @RequestParam(value = "userId", required = false) Long userId,
                                                              HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        return ResponseEntity.ok(forumPostFacadeService.getBriefInfo(postId, userId, areaCode,ip));
    }

    @ApiOperation(value = "4-95-6 帖子视频转码")
    @PostMapping("transcodePostVideo")
    public void transcodePostVideo(@RequestParam(value = "postId") Long postId) {
        forumPostFacadeService.transcodePostVideo(postId, null);
    }

    @ApiOperation(value = "4-95-7 批量替换帖子视频地址")
    @PostMapping("batchUpdatePostVideo")
    public void batchUpdatePostVideo(@RequestParam(value = "transcodeMapListJson") String transcodeMapListJson) {
        forumPostFacadeService.batchUpdatePostVideo(JSON.parseArray(transcodeMapListJson, TranscodeMap.class));
    }

    @ApiOperation(value = "4-95-8 获取用户最近七天内发的帖子")
    @GetMapping("getForumPostByUserId")
    public ResponseEntity<BaseForumPostDTO> getForumPostByUserId(@RequestParam(value = "targetUserId") Long targetUserId,
                                                                @RequestParam(value = "userId") Long userId) {
        return ResponseEntity.ok(forumPostFacadeService.getForumPostByUserId(userId,targetUserId));
    }

    @ApiOperation(value = "4-95-9 批量获取用户帖子图片")
    @GetMapping("batchGetUserImg")
    public ResponseEntity<List<UserImgVo>> batchGetUserImg(@RequestParam(value = "userIdList") List<Long> userIdList,
                                                           @RequestParam(value = "currentUserId", required = false) Long currentUserId) {
        return ResponseEntity.ok(forumPostFacadeService.batchGetUserImg(userIdList, currentUserId));
    }

    @GetMapping(value = "getTopicById")
    @ApiOperation(value = "4-95-10 根据id获取话题信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "话题ID", required = true),
    })
    public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
        return ResponseEntity.ok(forumPostFacadeService.getTopicById(id));
    }

    @ApiOperation(value = "4-95-11 获取帖子简略信息,不走详情查询（太重了）")
    @ApiImplicitParam(name = "postId", value = "帖子ID", required = true)
    @GetMapping("lightweight")
    public ResponseEntity<ForumPostBriefInfoDto> getPostWithoutDetail(@RequestParam("postId") Long postId){
        return ResponseEntity.ok(forumPostFacadeService.getBriefInfo(postId));
    }

    @ApiOperation(value = "4-95-12 发帖榜")
    @ApiImplicitParam(name = "areaCode", value = "areaCode", required = true)
    @GetMapping("forumRank")
    public ResponseEntity<List<ForumRankVo>> forumRank(@RequestParam("areaCode") String areaCode,@RequestParam
            ("userIds") List<Long> userIds){
        return ResponseEntity.ok(forumPostFacadeService.forumRank(areaCode,userIds));
    }

    @ApiOperation(value = "4-95-13 个人发帖榜热度")
    @ApiImplicitParam(name = "areaCode", value = "areaCode", required = true)
    @GetMapping("forumRankForUser")
    public ResponseEntity<ForumPostRankForUserVo> forumRankForUser(@RequestParam("userId") Long userId){
        return ResponseEntity.ok(forumPostFacadeService.forumRankForUser(userId));
    }

    @GetMapping(value = "getForumPostById")
    @ApiOperation(value = "4-95-14 根据id获取帖子信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
    })
    public ResponseEntity<ForumPostVo> getForumPostById(Long id) {
        return ResponseEntity.ok(forumPostFacadeService.getForumPostById(id));
    }

    @ApiOperation(value = "4-95-15 获取评论排行")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码"),
            @ApiImplicitParam(name = "limitNum", value = "截取排行条数")
    })
    @GetMapping("interactRankInfo")
    public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam
                                                                              ("areaCode") String areaCode, @RequestParam("limitNum") Integer limitNum, @RequestParam("userIds") List<Long> userIds){
        return ResponseEntity.ok(forumPostFacadeService.getInteractRankInfo(areaCode,limitNum,userIds));
    }

    @ApiOperation(value = "4-95-16 获取个人评论数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "userId")
    })
    @GetMapping("replyNumForUser")
    public ResponseEntity<Integer> replyNumForUser(@RequestParam("userId") Long userId){
        return ResponseEntity.ok(forumPostFacadeService.replyNumForUser(userId));
    }

    @ApiOperation(value = "4-95-17 获取某个地区下的热门新闻帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping("getTopPost")
    public ResponseEntity<List<ShareContentDTO>> getTopPost(@RequestParam("areaCode") String areaCode){
        return ResponseEntity.ok(shareRankService.getTopPost(areaCode));
    }

    @ApiOperation(value = "4-95-18 生成or更新帖子")
    @PostMapping("createOrUpdatePost")
    public ResponseEntity<Message> doInternalCreateOrUpdatePost(@RequestBody ForumPostFacadeParam param) {
        return ResponseEntity.ok(forumPostService.doInternalCreateOrUpdatePost(param));
    }

}
