package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.param.OptimizationNoticeParam;
import com.bxm.localnews.news.service.MixRecommandQuarzService;

import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "4-97 [内部]混合推荐接口")
@RestController
@RequestMapping("/facade/mixRecommend")
public class MixRecommendFacadeController {

    private final MixRecommandQuarzService mixRecommandQuarzService;

    @Autowired
    public MixRecommendFacadeController(MixRecommandQuarzService mixRecommandQuarzService) {
        this.mixRecommandQuarzService = mixRecommandQuarzService;
    }

    @PostMapping("/optimizationNotice")
    public Boolean optimizationNotice(@RequestBody OptimizationNoticeParam optimizationNoticeParam) {
        return mixRecommandQuarzService.doSendOptimizationNotice(optimizationNoticeParam);
    }

}
