package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.NewsBriefInfoDto;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Api(tags = "4-96 [内部]新闻相关接口")
@RestController
@RequestMapping("facade/news")
public class NewsFacadeController {

    @Resource
    private NewsService newsService;

    @ApiOperation(value = "4-96-1 获取新闻简略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "访问请求来源用户所属区域编码"),
            @ApiImplicitParam(name = "userId", value = "访问接口的用户ID")
    })
    @GetMapping("briefInfo")
    public ResponseEntity<NewsBriefInfoDto> getBriefInfo(@RequestParam("newsId") Long newsId,
                                                         @RequestParam(value = "areaCode", required = false) String areaCode,
                                                         @RequestParam(value = "userId", required = false) Long userId,
                                                         HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        NewsParam param = new NewsParam();
        param.setAreaCode(areaCode);
        param.setNewsId(newsId);
        param.setUserId(userId);

        Json<NewsDetailVO> newsDetailVOJson = newsService.getNewsDetailById(param, new BasicParam(),ip);
        NewsVO result = newsDetailVOJson.getResult().getNews();

        NewsBriefInfoDto newsBriefInfoDto = new NewsBriefInfoDto();
        newsBriefInfoDto.setId(result.getId());
        newsBriefInfoDto.setTitle(result.getTitle());
        newsBriefInfoDto.setHasVote(false);

        PostImgVo shareImgVo = result.getShareImg();
        if (null != shareImgVo) {
            newsBriefInfoDto.setConvertImgUrl(shareImgVo.getImgUrl());
        }
        return ResponseEntity.ok(newsBriefInfoDto);
    }
}
