package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.service.SensitiveWordService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-98 [内部]敏感词接口")
@RestController
@RequestMapping("/facade/sensitive")
public class SensitiveWordFacadeController {

    private final SensitiveWordService sensitiveWordService;

    @Autowired
    public SensitiveWordFacadeController(SensitiveWordService sensitiveWordService) {
        this.sensitiveWordService = sensitiveWordService;
    }

    @PostMapping("/verify")
    public ResponseEntity<Boolean> verifySensitiveWord(@RequestBody String text) {
        return ResponseEntity.ok(sensitiveWordService.contains(text));
    }

    @GetMapping("/reload")
    public ResponseEntity<Boolean> reloadSensitiveWord() {
        sensitiveWordService.reload();
        return ResponseEntity.ok(true);
    }
}
