package com.bxm.localnews.news.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * V3.4.0 通过消费用户定位信息变更实现位置更新，仅保留接口，防止调用出错
 *
 * @Author: pf.w
 * @Date: 2020/6/23 14:19
 */
@Api(tags = "4-94 [内部]同步用户位置信息", description = "同步用户位置信息", hidden = true)
@RestController
@RequestMapping("facade/news/location")
public class UserLocationSyncFacadeController {

    @ApiOperation(value = "4-94-1 同步用户位置信息", notes = "同步用户位置信息")
    @PostMapping("sync")
    public void syncUserLocation(@RequestParam(required = true) Long userId, @RequestParam String
            areaCode) {
    }

    @ApiOperation(value = "4-94-2 更新用户位置信息", notes = "更新用户位置信息")
    @PostMapping("update")
    public void updateUserLocation(@RequestParam(required = true) Long userId, @RequestParam(required = true) String
            areaCode) {
    }
}
