/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.UserLikeDTO;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.InitTagService;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.service.NewsRecommendedService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.service.UserTagService;
import com.bxm.localnews.news.service.WeightService;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.tools.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-90 [\u5185\u90e8]\u7528\u6237\u65b0\u95fb\u753b\u50cf\u521d\u59cb\u5316"}, description="\u9ed8\u8ba4\u7528\u6237\u3001\u65b0\u6ce8\u518c\u7528\u6237\uff0c\u7ed9\u5176\u5bf9\u5e94\u7684\u65b0\u95fb\u753b\u50cf\u3001\u6807\u7b7e")
@RestController
@RequestMapping(value={"facade/news"})
public class UserInitController {
    private NewsKindService newsKindService;
    private InitTagService initTagService;
    private UserTagService userTagService;
    private NewsRecommendedService newsRecommendedService;
    private UserKindService userKindService;
    private NewNewsReplyService newsReplyService;
    private WeightService weightService;
    private ForumPostService forumPostService;
    private NewsService newsService;

    @Autowired
    public UserInitController(NewsKindService newsKindService, InitTagService initTagService, UserTagService userTagService, NewsRecommendedService newsRecommendedService, UserKindService userKindService, NewNewsReplyService newsReplyService, WeightService weightService, ForumPostService forumPostService, NewsService newsService) {
        this.newsKindService = newsKindService;
        this.initTagService = initTagService;
        this.userTagService = userTagService;
        this.newsRecommendedService = newsRecommendedService;
        this.userKindService = userKindService;
        this.weightService = weightService;
        this.newsReplyService = newsReplyService;
        this.forumPostService = forumPostService;
        this.newsService = newsService;
    }

    @ApiOperation(value="4-90-1 [\u7528\u6237]\u521d\u59cb\u5316\u7528\u6237", notes="\u521d\u59cb\u5316\u7528\u6237\u7684\u9891\u9053\u548c\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newUserId", value="\u65b0\u6ce8\u518c\u7528\u6237ID"), @ApiImplicitParam(name="defaultUserId", value="\u9759\u9ed8\u7528\u6237ID")})
    @PostMapping(value={"init"})
    public void initUser(@RequestParam Long newUserId, @RequestParam(required=false) Long defaultUserId) {
        Date copyStartDate = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        if (null == defaultUserId) {
            this.newsKindService.createUserDefaultKinds(newUserId);
            this.initTagService.createInitTags(newUserId);
        } else {
            this.userTagService.doCopyTags(defaultUserId, newUserId, copyStartDate);
            this.newsRecommendedService.copyRecommendeds(defaultUserId, newUserId, copyStartDate);
            this.userKindService.copyKinds(defaultUserId, newUserId);
        }
    }

    @ApiOperation(value="4-90-2 [\u7528\u6237]\u540c\u6b65\u7528\u6237\u4fe1\u606f", notes="\u7528\u6237\u4fe1\u606f\u53d8\u66f4\u540e\uff0c\u540c\u6b65\u5197\u4f59\u7528\u6237\u5b57\u6bb5")
    @PostMapping(value={"sync"})
    public void syncUser(@RequestBody UserBean user) {
    }

    @ApiOperation(value="4-90-3 [\u63a8\u8350]\u91cd\u65b0\u8ba1\u7b97\u7528\u6237\u6807\u7b7e", notes="\u5728\u6570\u636e\u7684\u9010\u6b65\u63a8\u8350\u4e2d\uff0c\u8fdb\u884c\u6807\u7b7e\u7684\u70ed\u66f4\u65b0")
    @PostMapping(value={"/recalcu"})
    public Json add(Long userId) {
        this.weightService.recalcuUserTagWeight(userId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-90-4 \u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u7684\u8d5e\u6570", notes="\u6839\u636e\u7528\u6237id\u96c6\u5408\u67e5\u8be2\u8d5e\u6570")
    @PostMapping(value={"/getLikeNumByUserIds"})
    public ResponseEntity<List<UserLikeDTO>> getLikeNumByUserIds(@RequestBody List<Long> userIds) {
        return new ResponseEntity((Object)this.userTagService.getLikeNumByUserIds(userIds), HttpStatus.OK);
    }
}

