package com.bxm.localnews.news.manage.controller.forum;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminReplyLibraryParam;
import com.bxm.localnews.news.model.param.AdminReplyOriginalParam;
import com.bxm.localnews.news.model.param.ReplyCategoryParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibrary;
import com.bxm.localnews.news.service.AdminReplyLibraryService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-48 [管理]评论库管理", description = "评论库管理")
@RestController
@RequestMapping("api/admin/replyLibrary")
public class AdminReplyLibraryController extends BaseController {

    @Resource
    private AdminReplyLibraryService adminReplyLibraryService;

    @ApiOperation(value = "1-48-1 获取评论列表")
    @GetMapping("list")
    public Json<PageWarper<AdminReplyLibrary>> getList(AdminReplyLibraryParam param) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.getList(param));
    }

    @ApiOperation(value = "1-48-2 获取评论详情")
    @GetMapping("detail")
    public Json<AdminReplyLibrary> selectByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-48-3 批量新增评论")
    @PostMapping("batchInsert")
    public Json batchInsert(@RequestBody List<AdminReplyLibrary> adminReplyLibraryList) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.batchInsert(adminReplyLibraryList));
    }

    @ApiOperation(value = "1-48-4 编辑评论")
    @PostMapping("updateByPrimaryKey")
    public Json updateByPrimaryKey(AdminReplyLibrary adminReplyLibrary) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.updateByPrimaryKey(adminReplyLibrary));
    }

    @ApiOperation(value = "1-48-5 删除评论")
    @PostMapping("deleteByPrimaryKey")
    public Json deleteByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.deleteByPrimaryKey(id));
    }

    @ApiOperation(value = "1-48-6 模拟评论生成")
    @PostMapping("generateVirtualReply")
    public Json generateVirtualReply(@RequestBody AdminReplyOriginalParam param) {
        adminReplyLibraryService.generateVirtualReply(param);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-48-7 根据评论类型获得获得虚拟评论")
    @PostMapping("getReplyByCategoryId")
    public Json<List<AdminReplyLibrary>> getReplyByCategoryId(@RequestBody ReplyCategoryParam param) {
        return ResultUtil.genSuccessResult(adminReplyLibraryService.getReplyByCategoryId(param));
    }
}

