package com.bxm.localnews.news.manage.controller.forum;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminTopicParam;
import com.bxm.localnews.news.model.param.AdminTopicUpdateParam;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.service.AdminTopicService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-41 [管理]话题管理", description = "话题管理")
@RestController
@RequestMapping("api/admin/topic")
public class AdminTopicController extends BaseController {

    @Resource
    private AdminTopicService adminTopicService;

    @ApiOperation(value = "1-41-1 获取话题列表")
    @GetMapping("list")
    public Json<PageWarper<AdminTopic>> getList(AdminTopicParam param) {
        return ResultUtil.genSuccessResult(adminTopicService.getList(param));
    }

    @ApiOperation(value = "1-41-2 获取话题详情")
    @GetMapping("detail")
    public Json<AdminTopic> getTopicById(Long id) {
        return ResultUtil.genSuccessResult(adminTopicService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-41-3 话题上下架删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态：0下架 1上架 2删除", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(adminTopicService.updateStatus(id, status));
    }

    @ApiOperation(value = "1-41-4 新增或编辑话题")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody AdminTopic adminTopic) {
        return ResultUtil.genSuccessResult(adminTopicService.saveOrUpdate(adminTopic));
    }

    @ApiOperation(value = "1-41-5 修改话题权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "order", value = "权重", required = true)
    })
    @PostMapping("updateOrder")
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult(adminTopicService.updateOrder(id, order));
    }

    @ApiOperation(value = "1-41-6 获取简单话题列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "key", value = "关键字")
    })
    @GetMapping("getSimpleList")
    public Json<List<AdminTopic>> getSimpleList(String key) {
        return ResultUtil.genSuccessResult(adminTopicService.getSimpleList(key));
    }

    @ApiOperation(value = "1-41-7 根据话题id获取话题下的帖子数")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true)
    })
    @GetMapping("getPostNumByTopicId")
    public Json<Integer> getPostNumByTopicId(Long id) {
        return ResultUtil.genSuccessResult(adminTopicService.getPostNumByTopicId(id));
    }

    @ApiOperation(value = "1-41-8 编辑帖子中的话题", notes = "为了扩展性，话题支持多个id")
    @PostMapping("/post/update")
    public Json updateTopicOrForum(@RequestBody AdminTopicUpdateParam adminTopicUpdateParam) {
        adminTopicService.resetForumPostTopic(adminTopicUpdateParam.getId(), adminTopicUpdateParam.getTopicIdList());
        return ResultUtil.genSuccessResult();
    }

}

