package com.bxm.localnews.news.manage.controller.forum;

import com.bxm.localnews.news.model.dto.VirtualReplyDTO;
import com.bxm.localnews.news.model.param.VirtualReplyListParam;
import com.bxm.localnews.news.service.impl.VirtualReplyService;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gonzo
 * @date 2020-10-22 16:19
 **/
@Api(tags = "1-54 [管理]马甲号评论相关接口", description = "马甲号评论相关接口")
@RestController
@AllArgsConstructor
@RequestMapping("manage/news/virtualReply")
public class VirtualReplyController {

    private final VirtualReplyService virtualReplyService;

    @ApiOperation(value = "1-54-1 分页获取马甲号的所有评论列表", notes = "按照时间顺序排序，最先的在前面")
    @GetMapping("list")
    public ResponseJson<PageWarper<VirtualReplyDTO>> list(VirtualReplyListParam param) {
        return ResponseJson.ok(virtualReplyService.listByParam(param));
    }

}
