package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminNewsMonitorConditionParam;
import com.bxm.localnews.news.model.param.AdminNewsMonitorParam;
import com.bxm.localnews.news.model.vo.AdminNewsMonitorBean;
import com.bxm.localnews.news.service.AdminNewsMonitorService;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-28 [管理]新闻监控指标管理", description = "用于对新闻新增数据进行监控报警")
@RestController
@RequestMapping("api/admin/news/monitor")
public class AdminNewsMonitorController {

    private AdminNewsMonitorService adminNewsMonitorService;

    @Autowired
    public AdminNewsMonitorController(AdminNewsMonitorService adminNewsMonitorService) {
        this.adminNewsMonitorService = adminNewsMonitorService;
    }

    @ApiOperation(value = "1-28-1 获取全部监控条件", notes = "查询、分页均使用此接口")
    @GetMapping("list")
    public Json<PageWarper<AdminNewsMonitorBean>> getAllCondition(AdminNewsMonitorParam param) {
        return ResultUtil.genSuccessResult(adminNewsMonitorService.queryByParam(param));
    }

    @ApiOperation(value = "1-28-2 保存新闻监控条件", notes = "新增、编辑时调用此接口.")
    @PostMapping
    public Json save(@RequestBody AdminNewsMonitorConditionParam param) {
        return ResultUtil.genSuccessResult(adminNewsMonitorService.save(param));
    }

    @ApiOperation(value = "1-28-3 获取监控条件详情")
    @ApiImplicitParam(name = "id", value = "监控条件ID")
    @GetMapping("/{id}")
    public Json<AdminNewsMonitorBean> get(@PathVariable Long id) {
        return ResultUtil.genSuccessResult(adminNewsMonitorService.get(id));
    }

    @ApiOperation(value = "1-28-4 删除监控条件")
    @ApiImplicitParam(name = "id", value = "监控条件ID")
    @PostMapping("/remove/{id}")
    public Json remove(@PathVariable Long id) {
        return ResultUtil.genSuccessResult(adminNewsMonitorService.remove(id));
    }
}
