package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.param.AdminAllReplyParam;
import com.bxm.localnews.news.model.param.AdminCommentReplyParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyOriginalParam;
import com.bxm.localnews.news.model.param.AdminNewsReplyParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api(tags = "1-35 [管理]新闻管理中评论管理", description = "新闻评论管理，包括新闻评论的模拟生成，添加，删除")
@RestController
@RequestMapping("api/admin/news/reply")
public class AdminNewsReplyController {

    @Autowired
    private AdminNewsReplyService adminNewsReplyService;

    @ApiOperation("1-35-1 模拟评论生成")
    @PostMapping("/virtual")
    public Json generate(@RequestBody AdminNewsReplyOriginalParam adminNewsReplyOriginalParam) {
        if (adminNewsReplyOriginalParam.getNewsId() != null) {
            return this.adminNewsReplyService.doGenerateReply(adminNewsReplyOriginalParam);
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("1-35-2 新闻下评论分页")
    @GetMapping("/list")
    public Json<PageWarper<AdminNewsReply>> queryPage(AdminNewsReplyParam adminNewsReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listNewsReply(adminNewsReplyParam));
    }

    @ApiOperation("1-35-3 评论删除")
    @PostMapping("/del")
    public Json del(@RequestParam Long replyId, @RequestParam Long newsId) {
        if (newsId != null) {
            this.adminNewsReplyService.delReply(replyId, newsId);
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("1-35-4 增加评论回复")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parentReplyId", value = "上级评论id", required = true),
            @ApiImplicitParam(name = "replyContent", value = "评论内容", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "virtualUserId", value = "马甲号用户id", required = true),
            @ApiImplicitParam(name = "virtualHeadImg", value = "马甲号用户头像", required = true),
            @ApiImplicitParam(name = "virtualNickName", value = "马甲号用户昵称", required = true),
            @ApiImplicitParam(name = "replyTime", value = "评论回复时间", required = true),

    })
    @PostMapping("/addCommentReply")
    public Json addCommentReply(AdminCommentReplyParam adminCommentReplyParam) {
        int result = adminNewsReplyService.doAddCommentReply(adminCommentReplyParam);
//        if (result > 0){
//            Date currentTime = new Date();
//            //展示时间是否小于当前时间调用新闻扫描评论的接口
//            if (currentTime.compareTo(adminCommentReplyParam.getReplyTime()) >= 0){
//                newsIntegrationService.updateNewsReplyStatus();
//            }
//            return ResultUtil.genSuccessResult("添加评论成功!");
//        }
        return ResultUtil.genSuccessMsg("添加评论成功");

    }


    @ApiOperation("1-35-5 评论分页")
    @GetMapping("/allList")
    public Json<PageWarper<AdminReplyDTOAdmin>> queryAllList(AdminAllReplyParam adminAllReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listAllNewsReply(adminAllReplyParam));
    }

    @ApiOperation("1-35-6 评论详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "replyId", value = "评论id", required = true),
    })
    @GetMapping("/getReplyDetail")
    public Json<AdminReplyDetailDTO> getReplyDetail(Long newsId, Long replyId) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.getReplyDetail(newsId, replyId));
    }

}

