package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.param.VideoParam;
import com.bxm.localnews.news.model.param.VideoUpdateParam;
import com.bxm.localnews.news.model.vo.AdminVideo;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-32 [管理]后台小视频管理接口", description = "包含上线、下线、编辑功能")
@RestController
@RequestMapping("api/admin/video")
public class AdminVideoController {

    @ApiOperation(value = "1-32-1 小视频获取分页列表", notes = "获取小视频分页列表")
    @PostMapping(value = "/list")
    public Json<PageWarper<AdminVideo>> pageVideoList(VideoParam videoParam) {
        return ResultUtil.genSuccessResult(new PageWarper<AdminVideo>());
    }

    @ApiOperation("1-32-2 小视频上下架")
    @PostMapping("/upper")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    public Json updateNewsStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessMsg("更新成功");
    }

    @ApiOperation("1-32-3 小视频批量上下架")
    @PostMapping("/batchUpper")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    public Json updateNewsStatusByIds(String ids, Byte status) {
        return ResultUtil.genSuccessMsg("更新成功");
    }

    @ApiOperation("1-32-4 小视频获取详情")
    @GetMapping("/getNewsDetail")
    public Json<AdminVideo> getNewsDetail(Long id) {
        return ResultUtil.genSuccessResult(new AdminVideo());
    }

    @ApiOperation("1-32-5 小视频修改详情")
    @PostMapping("/update")
    public Json update(VideoUpdateParam param) {
        return ResultUtil.genSuccessMsg("更新成功");
    }

}
