package com.bxm.localnews.news.manage.controller.news;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.vo.AdminVideoFetchKeyword;
import com.bxm.localnews.news.service.AdminVideoFetchKeywordService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-23 小视频关键词管理", description = "小视频关键词管理")
@RestController
@RequestMapping("api/admin")
public class AdminVideoFetchKeywordController {

    private AdminVideoFetchKeywordService adminVideoFetchKeywordService;

    @Autowired
    public AdminVideoFetchKeywordController(AdminVideoFetchKeywordService adminVideoFetchKeywordService) {
        this.adminVideoFetchKeywordService = adminVideoFetchKeywordService;
    }

    @PostMapping(value = "/video/keyword/list")
    @ApiOperation(value = "1-23-01 小视频拉取关键字列表", notes = "小视频拉取关键字列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "分页当前页", required = true),
            @ApiImplicitParam(name = "pageSize", value = "分页大小", required = true)
    })
    public Json<PageWarper<AdminVideoFetchKeyword>> pageKeywordList(
            @RequestParam("pageNum") Integer pageNum,
            @RequestParam("pageSize") Integer pageSize) {
        PageParam pageParam = new PageParam();
        pageParam.setPageNum(pageNum);
        pageParam.setPageSize(pageSize);
        PageWarper<AdminVideoFetchKeyword> pageInfo = adminVideoFetchKeywordService.pageList(pageParam);
        return ResultUtil.genSuccessResult(pageInfo);
    }


    @PostMapping(value = "/video/keyword/save")
    @ApiOperation(value = "1-23-02 新增小视频关键字", notes = "新增小视频关键字")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "关键词", required = true)
    })
    public Json save(@RequestParam("name") String name) {
        adminVideoFetchKeywordService.insert(name);
        return ResultUtil.genSuccessResult();
    }

    @PostMapping(value = "/video/keyword/delete")
    @ApiOperation(value = "1-23-03 删除小视频关键字", notes = "删除小视频关键字")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "关键词", required = true)
    })
    public Json delete(@RequestParam("id") Long id) {
        adminVideoFetchKeywordService.delete(id);
        return ResultUtil.genSuccessResult();
    }
}
