package com.bxm.localnews.news.manage.controller.recommend;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.model.dto.AdminMixRecommandDTO;
import com.bxm.localnews.news.model.param.AdminMixPoolParam;
import com.bxm.localnews.news.model.param.AdminMixRecommandParam;
import com.bxm.localnews.news.model.param.AdminMixRecommendTopParam;
import com.bxm.localnews.news.service.AdminMixRecommendPoolService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;


@RestController
@Slf4j
@Api(tags = "1-44[管理]推荐池管理", description = "推荐池相关操作")
@RequestMapping("/api/mixRecommand")
public class AdminMixRecommendPoolController {

    @Autowired
    private AdminMixRecommendPoolService adminMixRecommendPoolService;

    @PostMapping("/list")
    @ApiOperation(value = "1-44-01 获得推荐库列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "投放地区", required = true),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = true),
            @ApiImplicitParam(name = "title", value = "标题", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每页显示数量 默认值为10", required = true),
            @ApiImplicitParam(name = "pageNum", value = "当前页", required = true),
            @ApiImplicitParam(name = "author", value = "作者", required = true),
            @ApiImplicitParam(name = "recommendStartTime", value = "定时推荐开始时间", required = true),
            @ApiImplicitParam(name = "recommendEndTime", value = "定时推荐结束时间", required = true),
            @ApiImplicitParam(name = "userId", value = "作者id", required = false)
    })
    public Json<PageWarper<AdminMixRecommandDTO>> getPaginationList(AdminMixRecommandParam adminMixRecommandParam) {
        PageWarper<AdminMixRecommandDTO> pages = adminMixRecommendPoolService.listPagination(adminMixRecommandParam);
        return ResultUtil.genSuccessResult(pages);
    }

    @PostMapping("/cancelRecommendById")
    @ApiOperation(value = "1-44-02 取消推荐")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = true)
    })
    public Json cancelRecommendById(AdminMixPoolParam adminMixPoolParam) {
        adminMixRecommendPoolService.doCancelMixRecommend(adminMixPoolParam);
        return ResultUtil.genSuccessMsg("取消推荐成功!");
    }


    @PostMapping("/updateMixRecommandWeight")
    @ApiOperation(value = "1-44-03 修改推荐池权重")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "新闻id", required = true),
            @ApiImplicitParam(name = "origin", value = "类型 1：社区帖子2：本地新闻 3：全国新闻", required = true),
            @ApiImplicitParam(name = "weight", value = "权重", required = true)
    })
    public Json updateMixRecommandWeight(AdminMixPoolParam adminMixPoolParam, Integer weight) {
        adminMixRecommendPoolService.updateMixRecommendWeight(adminMixPoolParam, weight);
        return ResultUtil.genSuccessMsg("取消推荐成功!");
    }


    @PostMapping("/addTop")
    @ApiOperation(value = "1-44-04 推荐池置顶")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id,多个新闻id用,分隔", required = true),
            @ApiImplicitParam(name = "newsEffectiveTime", value = "新闻生效时间", required = true),
            @ApiImplicitParam(name = "newsExpireTime", value = "新闻置顶失效时间", required = true),
            @ApiImplicitParam(name = "postId", value = "新闻id,多个新闻id用,分隔", required = true),
            @ApiImplicitParam(name = "postEffectiveTime", value = "新闻生效时间", required = true),
            @ApiImplicitParam(name = "postExpireTime", value = "新闻置顶失效时间", required = true)
    })
    @Deprecated
    public Json addTop(AdminMixRecommendTopParam mixPoolParam) {
        adminMixRecommendPoolService.addTop(mixPoolParam);
        return ResultUtil.genSuccessMsg("推荐池置顶成功!");
    }


    @PostMapping("/updateRecommandTime")
    @ApiOperation(value = "1-44-05 更新推荐池推荐时间")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "推荐库id", required = true),
            @ApiImplicitParam(name = "recommendTime", value = "新闻生效时间", required = true)
    })
    public Json updateRecommandTime(Long id, @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT) Date recommendTime) {
        adminMixRecommendPoolService.doUpdateRecommendTimeById(id, recommendTime);
        return ResultUtil.genSuccessMsg("更新推荐池推荐时间成功!");
    }


}

