package com.bxm.localnews.news.dto;

import java.util.Date;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "新闻收藏")
public class NewsCollectDTO extends BaseBean {

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("视频播放地址")
    private String videoAddress;

    @ApiModelProperty("新闻类型")
    private Integer type;

    @ApiModelProperty("收藏时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("新闻类别")
    private String kindName;

    @ApiModelProperty("作者")
    private String author;

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVideoAddress() {
        return videoAddress;
    }

    public void setVideoAddress(String videoAddress) {
        this.videoAddress = videoAddress;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getKindName() {
        return this.kindName;
    }

    public void setKindName(String kindName) {
        this.kindName = kindName;
    }

}
