package com.bxm.localnews.news.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "新闻详情")
public class News {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("新闻网络图片地址（json字符串格式）")
    private String imgUrl;

    @ApiModelProperty("组图类型--图片张数")
    private Integer imgNum;

    @ApiModelProperty("视频长度 单位秒")
    private Integer videoLen;

    @ApiModelProperty("主题词 多个之间用逗号隔开")
    private String theme;

    @ApiModelProperty("作者头像")
    private String authorImg;

    @ApiModelProperty("来源作者")
    private String author;

    @ApiModelProperty("来源地址")
    private String address;

    @ApiModelProperty("视频播放地址")
    private String videoAddress;

    @ApiModelProperty("分类id（一篇文章对应一个分类）")
    private Integer kindId;

    @ApiModelProperty("分享次数")
    private Long shares;

    @ApiModelProperty("浏览次数")
    private Long views;

    @ApiModelProperty("新闻抓取时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("新闻发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date issueTime;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("新闻类型  1：文章  2：组图  3：视频")
    private Byte type;

    @ApiModelProperty("新闻渠道 1：今日头条 2：搜狐 3:凤凰 4:UC,5网易,6猫扑,7快资讯")
    private Byte channel;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("在头条里面的ID")
    private String groupId;

    @ApiModelProperty("标签")
    private String label;

    @ApiModelProperty("是否是热文 1：否  2：是")
    private Byte hot;

    @ApiModelProperty("新闻详情跳转地址")
    private String linkUrl;
    @ApiModelProperty("是否是活动 1：否 2：是")
    private Byte activity;
    @ApiModelProperty("是否是本地新闻 1：否 2：是")
    private Byte local;
    @ApiModelProperty("标签")
    private Integer showLevel;

    @ApiModelProperty("标签冗余")
    private String showLevelDetail;

    @ApiModelProperty("投放类型 0全国 1地区")
    private Integer deliveryType;
    @ApiModelProperty("地区冗余")
    private String areaDetail;


    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail;
    }

    public String getShowLevelDetail() {
        return showLevelDetail;
    }

    public void setShowLevelDetail(String showLevelDetail) {
        this.showLevelDetail = showLevelDetail;
    }

    public Integer getShowLevel() {
        return showLevel;
    }

    public void setShowLevel(Integer showLevel) {
        this.showLevel = showLevel;
    }

    public Byte getHot() {
        return this.hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        if (imgUrl != null) {
            this.imgUrl = StringUtils.equals(imgUrl, "[]") ? null : imgUrl.trim();
        }
    }

    public Integer getImgNum() {
        return this.imgNum;
    }

    public void setImgNum(Integer imgNum) {
        this.imgNum = imgNum;
    }

    public Integer getVideoLen() {
        return this.videoLen;
    }

    public void setVideoLen(Integer videoLen) {
        this.videoLen = videoLen;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme == null ? null : theme.trim();
    }

    public String getAuthorImg() {
        return this.authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg == null ? null : authorImg.trim();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author == null ? null : author.trim();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getVideoAddress() {
        return this.videoAddress;
    }

    public void setVideoAddress(String videoAddress) {
        this.videoAddress = videoAddress == null ? null : videoAddress.trim();
    }

    public Integer getKindId() {
        return this.kindId;
    }

    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    public Long getShares() {
        return this.shares;
    }

    public void setShares(Long shares) {
        this.shares = shares;
    }

    public Long getViews() {
        return this.views;
    }

    public void setViews(Long views) {
        this.views = views;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Byte getStatus() {
        return this.status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getTop() {
        return this.top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getChannel() {
        return this.channel;
    }

    public void setChannel(Byte channel) {
        this.channel = channel;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Byte getActivity() {
        return activity;
    }

    public void setActivity(Byte activity) {
        this.activity = activity;
    }

    public Byte getLocal() {
        return local;
    }

    public void setLocal(Byte local) {
        this.local = local;
    }
}