package com.bxm.localnews.news.vo;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IUserIdSharding;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "新闻置顶列表参数")
public class NewsTopListParam extends BasicParam implements IUserIdSharding {

    /** **/
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "当前用户的所属区域，用于进行地方新闻推荐")
    private String            areaCode;

    @ApiModelProperty(value = "当前请求的用户ID")
    private Long              userId;

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
