package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author gonzo
 * @date 2020-10-22 19:57
 **/
@Data
@ApiModel(description = "马甲号评论列表")
public class VirtualReplyDTO {

    @ApiModelProperty(value = "评论id")
    private Long id;

    @ApiModelProperty(value = "帖子id")
    private Long newsId;

    @ApiModelProperty(value = "帖子标题")
    private String newsTitle;

    @ApiModelProperty(value = "接受马甲号昵称")
    private String virtualNickName;

    @ApiModelProperty(value = "接受马甲号id")
    private Long virtualUserId;

    @ApiModelProperty(value = "评论用户昵称")
    private String userNickName;

    @ApiModelProperty(value = "评论用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "是否回复 0: 未回复 1: 已回复", example = "0")
    private Integer replyStatus;

    @ApiModelProperty(value = "回复内容")
    private String replyContent;

    @ApiModelProperty(value = "回复时间")
    private String replyTime;

    @ApiModelProperty(value = "马甲号投放地区信息")
    private String virtualAreaNames;

}
