package com.bxm.localnews.news.model.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 特殊帖子的类型
 *
 * @author gonzo
 * @date 2020-11-25 15:56
 **/
public enum SpecialForumEnum {

    /**
     * 新人报道帖子
     */
    NOVICE(1),
        ;

    private int type;

    SpecialForumEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }


    /**
     * 根据type 获取对应的枚举类型
     *
     * @param type type
     * @return 枚举类型
     */
    public static Optional<SpecialForumEnum> getByType(int type) {
        return Arrays.stream(SpecialForumEnum.values()).filter(p -> p.getType() == type).findAny();
    }

}
