package com.bxm.localnews.news.model.param;

import lombok.Data;

import java.util.List;

/**
 * 随机查询马甲信息
 *
 * @author liujia
 * @date 2020-08-06 17:58
 **/
@Data
public class VirtualUserRandomQueryParam {
    /**
     * 获取数量
     */
    private Integer num;

    /**
     * 马甲类型
     */
    private Byte type;

    /**
     * 存在的用户ID
     */
    private List<Long> exitUserId;

    /**
     * 指定的检索区域
     */
    private String areaCode;

    /**
     * 投放区域，0：全局投放，1：区域投放
     */
    private Integer deliveryType;

    /**
     * 区域投放时选择的指定区域
     */
    private List<String> includeAreaCodes;
}
