package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@ApiModel(description = "帖子点赞返回实体")
@Data
@Builder
public class AdminForumPostLike {

    @ApiModelProperty("点赞id")
    private Long id;

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("点赞人用户id")
    private Long userId;

    @ApiModelProperty("点赞人用户昵称")
    private String userNickname;

    @ApiModelProperty("点赞人用户头像")
    private String headImg;

    @ApiModelProperty("是否展示,0不展示,1展示")
    private Byte isShow;

    @ApiModelProperty("是否马甲号,0不是,1是")
    private Byte isVest;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("0:取消点赞，1：点赞")
    private Byte type;

    @Tolerate
    public AdminForumPostLike() {
    }

}

