package com.bxm.localnews.news.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 发帖奖励记录表
 */
@Data
public class PostAwardBean implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 发放奖励的运营账号ID
     */
    private Long operator;

    /**
     * 发帖人
     */
    private Long userId;

    /**
     * 帖子ID
     */
    private Long postId;

    /**
     * 奖励类型，0：金币，1：现金
     */
    private Integer awardType;

    /**
     * 奖励金额
     */
    private BigDecimal awardAmount;

    /**
     * 记录创建时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}