package com.bxm.localnews.news.action;

import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostVo;

/**
 * 帖子点击、点击数相关逻辑
 *
 * @author liujia
 * @date 1/18/21 4:06 PM
 **/
public interface PostClickService {

    /**
     * 设置帖子的初始化点击数量
     *
     * @param adminForumPost        帖子信息
     * @param existedAdminForumPost 历史帖子信息
     */
    void setClickCountInfo(AdminForumPost adminForumPost, AdminForumPost existedAdminForumPost);

    /**
     * 对帖子的点击次数进行消费，对帖子的次数进行增加
     *
     * @param forumPostVo 帖子信息 可为null
     */
    void doConsumeClickCount(Long postId, Long userId, ForumPostVo forumPostVo);

    /**
     * 对帖子的有效阅读次数进行消费，对帖子的次数进行增加
     *
     * @param postId
     * @param userId
     */
    void doConsumeActiveViewCount(Long postId, Long userId);

    /**
     * 移除帖子的阅读审核限制
     *
     * @param postId 帖子ID
     */
    void removePostReadLimit(Long postId);

    /**
     * 帖子被阅读后的处理逻辑
     *
     * @param userId
     * @param postId
     * @param shareUserId
     * @param platform
     * @param forumPostVo
     * @param ip
     */
    void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo, String ip);

    /**
     * 记录帖子阅读信息
     *
     * @param userId
     * @param postId
     * @param shareUserId
     * @param platform
     * @param forumPostVo
     */
    void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo);
}
