package com.bxm.localnews.news.action;

import com.bxm.localnews.news.model.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.model.dto.PostLikeDto;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostLike;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.vo.Message;

import java.util.Date;
import java.util.List;

/**
 * 帖子点赞相关逻辑
 *
 * @author liujia
 * @date 1/15/21 9:33 AM
 **/
public interface PostLikeService {

    /**
     * 小程序帖子点赞
     *
     * @param postId   帖子id
     * @param userId   用户id
     * @param areaCode 地区编码
     * @return
     */
    PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, Integer platform);

    /**
     * 查看详情中的点赞列表
     *
     * @param id
     * @param userId
     * @param devcId
     * @return
     */
    List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId);

    /**
     * 对某篇帖子进行点赞操作
     *
     * @param userId
     * @param postId
     * @param type
     * @param areaCode
     */
    void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform);

    /**
     * 帖子添加马甲号点赞
     *
     * @param postId
     * @param startTime
     * @param endTime
     * @param num
     * @return
     */
    Message doAddPostLike(Long postId, Date startTime, Date endTime, Integer num);

    /**
     * 为帖子增加模拟数据
     */
    void simulateData(AdminForumPost adminForumPost);

    /**
     * 帖子点赞异步执行
     *
     * @param userId
     * @param postId
     * @param type     1点赞,0取消点赞
     * @param areaCode
     * @param isOld
     * @param platform
     */
    void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform);

    /**
     * 封装点赞返回实体
     *
     * @param postLikeDto
     * @param userId
     * @param userId1
     * @param postLikeConsume
     */
    void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long userId1, int postLikeConsume);

    /**
     * 点赞定时任务批量发送消息
     *
     * @param postLikes
     */
    void asyncSendPostLikeMessage(List<ForumPostLike> postLikes);

    /**
     * 得到帖子鲜花数量
     *
     * @param isBrilliant
     * @return
     */
    int getPostLikeConsume(Integer isBrilliant);

    /**
     * 定期刷新帖子的点赞信息，将模拟数据设置为显示状态
     *
     * @param postId 帖子ID，如果为空，则查询近期的全部数据
     */
    void doRefreshLikeInfo(Long postId);

    /**
     * 帖子点赞用户头像,用户昵称同步
     */
    void doSyncPostLikeInfo();

    /**
     * 用户更改信息后同步帖子点赞表的用户头像,用户昵称字段
     *
     * @param userId
     * @param nickname
     * @param headImg
     */
    void doTriggerUpdateForumPostLikeInfo(Long userId, String nickname, String headImg);

    /**
     * 更新帖子点赞数量
     *
     * @param type
     * @param postId
     */
    void doUpdateForumInfo(int type, Long postId);

    /**
     * 增加点赞数
     *
     * @param forumPostVo
     * @param num
     */
    void addPostLike(ForumPostVo forumPostVo, Integer num);
}
