package com.bxm.localnews.news.action.impl;

import com.bxm.localnews.news.action.PostReportService;
import com.bxm.localnews.news.domain.ForumPostInformMapper;
import com.bxm.localnews.news.model.param.ForumPostInformParam;
import com.bxm.localnews.news.model.vo.ForumPostInform;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liujia
 * @date 1/15/21 10:17 AM
 **/
@Service
@AllArgsConstructor
public class PostReportServiceImpl implements PostReportService {

    private ForumPostInformMapper forumPostInformMapper;

    private SequenceCreater sequenceCreater;

    @Override
    public Message doInformForumPost(ForumPostInformParam param) {
        ForumPostInform forumPostInformParam = new ForumPostInform();
        forumPostInformParam.setPostId(param.getPostId());
        forumPostInformParam.setUserId(param.getUserId());
        List<ForumPostInform> informList = this.forumPostInformMapper.selectByModel(forumPostInformParam);
        if (CollectionUtils.isNotEmpty(informList)) {
            return Message.build(false, "您已举报过");
        }
        ForumPostInform forumPostInform = new ForumPostInform();
        BeanUtils.copyProperties(param, forumPostInform);
        forumPostInform.setId(sequenceCreater.nextLongId());
        this.forumPostInformMapper.insertSelective(forumPostInform);
        return Message.build(true);
    }
}
