package com.bxm.localnews.news.activity;

import com.bxm.localnews.news.model.dto.activity.ActivityPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.param.activity.ActivityPostPageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 活动帖子相关业务逻辑
 *
 * @author liujia
 * @date 1/19/21 6:50 PM
 **/
public interface ActivityPostService {

    /**
     * 分页查询活动帖子列表
     *
     * @param param 分页查询参数
     * @return 分页结果
     */
    PageWarper<ActivityPostItemDTO> queryByPage(ActivityPostPageParam param);

    /**
     * 获取活动帖子详情
     *
     * @param postId 帖子ID
     * @return 活动帖子详情
     */
    ForumPostActivityEntity getDetail(Long postId);

    /**
     * 保存或新增活动帖子信息
     *
     * @param entity 活动帖子信息
     * @return 操作结果
     */
    Message save(ForumPostActivityEntity entity);
}
