package com.bxm.localnews.news.activity;

import com.bxm.localnews.common.vo.BasicParam;

import java.util.Optional;

/**
 * @author gonzo
 * @date 2020-09-28 19:52
 **/
public interface ForumTeachService {
    /**
     * 获取推荐的教育帖子id
     *
     * @param userId     教育目标用户
     * @param basicParam 基础参数
     * @return 推荐的id
     */
    Optional<Long> getTeachForumPostId(Long userId, BasicParam basicParam);

    /**
     * 更新用户教育帖子信息
     *
     * @param userId 用户id
     * @param newsId 帖子id
     */
    void updateTeachInfo(Long userId, Long newsId);
}
