package com.bxm.localnews.news.activity;

import com.bxm.localnews.news.model.vo.AdminForumPost;

/**
 * 发帖奖励相关接口
 *
 * @author liujia
 * @date 2020-08-08 10:12
 **/
public interface PostAwardService {

    /**
     * 当审核通过时给帖子发放奖励
     * 判断帖子是否有发放奖励的记录，如果不存在则允许发放奖励
     * 给用户流水增加对应金额的奖励
     * 给用户发推送推送消息
     *
     * @param post      帖子信息
     * @param postTitle 帖子标题，经过了特殊处理
     */
    void execGrantAward(AdminForumPost post, String postTitle);

}
