package com.bxm.localnews.news.activity.impl;

import com.bxm.localnews.dto.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.domain.activity.ForumPostActivityMapper;
import com.bxm.localnews.news.model.dto.activity.ActivityPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.param.activity.ActivityPostPageParam;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.topic.AdminTopicService;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author liujia
 * @date 1/19/21 6:54 PM
 **/
@AllArgsConstructor
@Service
@Slf4j
public class ActivityPostServiceImpl implements ActivityPostService {

    private ForumPostActivityMapper forumPostActivityMapper;

    private LocationIntegrationService locationIntegrationService;

    private AdminTopicService adminTopicService;

    private SequenceCreater sequenceCreater;

    private MerchantIntegrationService merchantIntegrationService;

    @Override
    public PageWarper<ActivityPostItemDTO> queryByPage(ActivityPostPageParam param) {
        List<ActivityPostItemDTO> result = forumPostActivityMapper.queryByPage(param);

        result.forEach(post -> {
            //设置地区
            if (StringUtils.isNotEmpty(post.getAreaDetail())) {
                String[] areaCodeArray = post.getAreaDetail().split(",");
                post.setAreaDetail(locationIntegrationService.batchGetDetailJson(areaCodeArray));
            }

            AdminTopic adminTopic = adminTopicService.selectByPrimaryKey(post.getTopicId());
            if (null != adminTopic) {
                post.setTopicName(adminTopic.getTitle());
            }


            post.setLinkUrl(ProtocolFactory.forumPost().outer()
                    .postId(post.getId())
                    .noExtend()
                    .userId(post.getUserId())
                    .build());
        });

        return new PageWarper<>(result);
    }

    @Override
    public ForumPostActivityEntity getDetail(Long postId) {
        return forumPostActivityMapper.selectByPostId(postId);
    }

    @Override
    public Message save(ForumPostActivityEntity entity) {
        ForumPostActivityEntity existsActivityPost = getDetail(entity.getPostId());

        if (entity.getGoodsId() != null) {
            GoodsInfoAndUserIdDTO goodsInfo = merchantIntegrationService.getMerchantGoodsById(entity.getGoodsId());
            // 获取商户信息，商户信息变更时同步变更
            entity.setMerchantId(goodsInfo.getMerchantId());
            entity.setMerchantName(goodsInfo.getMerchantName());

            String goodsDetailHtmlUrl = ProtocolFactory.goods().inner()
                    .enablePlaceHolder()
                    .goodsId(entity.getGoodsId())
                    .build();

            // 组装协议地址
            entity.setProtocol(ProtocolFactory.appH5().url(goodsDetailHtmlUrl).build());
        }

        int result;
        if (existsActivityPost == null) {
            entity.setId(sequenceCreater.nextLongId());
            entity.setCreateTime(new Date());

            if (StringUtils.isBlank(entity.getJoinText())) {
                entity.setJoinText("参与活动");
            }
            result = forumPostActivityMapper.insert(entity);
        } else {
            entity.setId(existsActivityPost.getId());
            entity.setModifyTime(new Date());
            entity.setCreator(null);

            result = forumPostActivityMapper.updateByPrimaryKeySelective(entity);
        }
        return Message.build(result);
    }


}













