package com.bxm.localnews.news.activity.impl;

import com.bxm.localnews.news.activity.ForumPostGuideService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.model.dto.ForumPostTodayDTO;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author liujia
 * @date 1/15/21 9:47 AM
 **/
@Slf4j
@Service
@AllArgsConstructor
public class ForumPostGuideServiceImpl implements ForumPostGuideService {

    private ForumPostMapper forumPostMapper;

    private RedisSetAdapter redisSetAdapter;

    private NewsProperties newsProperties;

    private ForumTopicService forumTopicService;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public ForumPostTodayDTO forumOkTodayForUser(Long userId) {
        //总的发帖数（排除新人贴）
        Integer forumsAll = forumPostMapper.forumsAllForUser(userId);

        //今日发帖数 （排除新人贴）
        Integer forumsToday = forumPostMapper.forumTodayForUser(userId);

        boolean flag = false;

        //今日未发帖 + 总发帖数小于等于3
        if (forumsAll <= 3 && forumsToday <= 0 && !redisSetAdapter.exists(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), userId)) {
            //开关
            if (newsProperties.getForumGuidePopFlag()) {
                flag = true;
                //存入缓存 一天只显示一次
                saveToRedis(userId);
            }
        }

        return ForumPostTodayDTO.builder()
                .title(newsProperties.getForumGuidePopTitle())
                .subTitle(newsProperties.getForumGuidePopSubTitle())
                .content(newsProperties.getForumGuidePopContent())
                .hasPost(flag ? 1 : 0)
                .build();
    }

    /**
     * 本地圈引导发帖弹窗缓存 一天一次
     *
     * @param userId 用户ID
     */
    private void saveToRedis(Long userId) {
        redisSetAdapter.add(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), userId);
        //失效时间为自然日一天
        redisSetAdapter.expire(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), DateUtils.getCurSeconds());
    }
}
